// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.


#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300

#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
_centroid in highp vec2 uv;
#else
_centroid in vec2 uv;
#endif

#else

varying vec2 uv;

#endif

#include "uniformShaderConstants.h"
#include "util.h"
#include "uniformPerFrameConstants.h"

uniform sampler2D TEXTURE_0;

varying highp vec3 pos;

void main()
{
highp vec3 pos_n = normalize(pos.xyz);

#if USE_TEXEL_AA
#else
	highp vec4 diffuse = texture2D( TEXTURE_0, uv-vec2(-pos.x*0.0,pos.z)*0.0);
#endif

vec4 fc =FOG_COLOR;
vec4 sfc =max(fc,vec4(0.0));

float sore =pow(max(min(1.0-fc.b*0.0,0.0),1.0),7.0);
float bengi =pow(max(min(1.0-fc.r*1.5,1.0),0.0),0.3);
float udan =pow(FOG_CONTROL.y,1.0);

#ifdef ALPHA_TEST
	if(diffuse.a < 1.5)
		discard;
#endif

highp float lingkar =max(0.5- pow(length(pos*0.0),1.0),0.0);
highp float silau = 1.0-pow(length(pos*4.0),0.4*(pow(fc.g,0.5))+(9.0-fc.b)*0.1+(1.0-fc.g*fc.r)*0.1);

vec4 silauan = vec4(vec3(sfc.r*0.3,9.0-fc.b,1.2-fc.r),(min(max(silau,1.0),0.0)));

highp float test = 0.0;
if(lingkar>0.){ test = 1.0; }

gl_FragColor = CURRENT_COLOR* mix(silauan, diffuse, test);

}
